# Generated Python Strategy for: PlayerA (meta)
# Run Index: 3
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerA_DeepSeek_V3_MetaAgent_Run3_Iter0(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial move: Cooperate
    if not my_history:
        return "C"
    
    # Heuristic analysis of opponent's code
    opponent_code = opponent_program_code.lower()
    
    # Check for simple strategies
    always_cooperate = "always_cooperate" in opponent_code or "return 'c'" in opponent_code
    always_defect = "always_defect" in opponent_code or "return 'd'" in opponent_code
    tit_for_tat = "tit_for_tat" in opponent_code or ("opp_history" in opponent_code and "my_history" in opponent_code and "return opp_history[-1]" in opponent_code)
    
    # Check for random behavior
    is_random = "random.choice(['c', 'd'])" in opponent_code or "random.randint" in opponent_code
    
    # Check for self-similarity (if opponent's code contains our function name or similar logic)
    self_similar = "playera_deepseek_v3_metaagent_run3_iter0" in opponent_code or "deepseek" in opponent_code
    
    # Count occurrences of 'C' and 'D' in the code
    c_count = opponent_code.count("'c'") + opponent_code.count("'C'")
    d_count = opponent_code.count("'d'") + opponent_code.count("'D'")
    
    # Determine opponent's likely strategy
    if always_cooperate:
        return "C"
    elif always_defect:
        return "D"
    elif tit_for_tat:
        return opp_history[-1] if opp_history else "C"
    elif is_random:
        return "D" if len(my_history) > 10 else "C"  # Defect later against random
    elif self_similar and c_count > d_count:
        return "C"
    elif self_similar and d_count > c_count:
        return "D"
    
    # Fallback to Tit-for-Tat with initial forgiveness
    if len(my_history) < 3:
        return "C"
    else:
        return opp_history[-1] if opp_history else "C"